package ru.yandex.search.mail.yt.consumer.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class YtConfigBuilder extends AbstractYtConfigBuilder<YtConfigBuilder> {
    public YtConfigBuilder() {
        this(YtConfigDefaults.INSTANCE);
    }

    public YtConfigBuilder(final YtConfig config) {
        super(config);
    }

    public YtConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, YtConfigDefaults.INSTANCE);
    }

    public YtConfigBuilder(
        final IniConfig config,
        final YtConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public YtConfigBuilder self() {
        return this;
    }

    public ImmutableYtConfig build() throws ConfigException {
        return new ImmutableYtConfig(this);
    }
}
