package ru.yandex.search.mail.yt.consumer.config;

import org.apache.http.HttpHost;

import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.http.config.HttpTargetConfig;

public class YtConfigDefaults implements YtConfig {
    public static final YtConfig INSTANCE = new YtConfigDefaults();
    private static final int DEFAULT_YT_CONNECTIONS = 10;
    private static final HttpHost DEFAULT_CLUSTER =
        new HttpHost("hahn.yt.yandex-team.ru");

    private static final HttpTargetConfig YT_CLIENT_DEFAULTS =
        new HttpHostConfigBuilder()
            .connections(DEFAULT_YT_CONNECTIONS);

    @Override
    public HttpHost cluster() {
        return DEFAULT_CLUSTER;
    }

    @Override
    public String account() {
        return "mail-search";
    }

    @Override
    public String home() {
        return "//home/mail-search";
    }

    @Override
    public String tmp() {
        return "//home/mail-search/tmp";
    }

    @Override
    public String token() {
        return null;
    }

    @Override
    public HttpTargetConfig clientConfig() {
        return YT_CLIENT_DEFAULTS;
    }
}
