package ru.yandex.search.mail.yt.consumer.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class YtConsumerConfigBuilder
    extends AbstractYtConsumerConfigBuilder<YtConsumerConfigBuilder>
{
    public YtConsumerConfigBuilder() {
        this(YtConsumerConfigDefaults.INSTANCE);
    }

    public YtConsumerConfigBuilder(final YtConsumerConfig config) {
        super(config);
    }

    public YtConsumerConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, YtConsumerConfigDefaults.INSTANCE);
    }

    public YtConsumerConfigBuilder(
        final IniConfig config,
        final YtConsumerConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public YtConsumerConfigBuilder self() {
        return this;
    }

    public ImmutableYtConsumerConfig build() throws ConfigException {
        return new ImmutableYtConsumerConfig(this);
    }
}
