package ru.yandex.search.mail.yt.consumer.mobile.actions;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.search.mail.yt.consumer.SourceConsumer;
import ru.yandex.search.mail.yt.consumer.YtConsumer;
import ru.yandex.search.mail.yt.consumer.config.ImmutableSourceConsumerConfig;
import ru.yandex.search.mail.yt.consumer.config.SourceConsumerBuildContext;
import ru.yandex.search.mail.yt.consumer.config.SourceConsumerConfigBuilder;
import ru.yandex.search.mail.yt.consumer.upload.SourceConsumerFactory;

public class MobileActionsConsumerBuildContext
    implements SourceConsumerBuildContext
{
    private final ImmutableSourceConsumerConfig config;

    public MobileActionsConsumerBuildContext(
        final IniConfig config)
        throws ConfigException
    {
        this.config = new SourceConsumerConfigBuilder(config).build();
    }

    @Override
    public SourceConsumerFactory factory() {
        return SourceConsumerFactory.MOBILE_ACTIONS;
    }

    @Override
    public SourceConsumer build(
        final YtConsumer consumer)
        throws ConfigException
    {
        return new MobileActionsSourceConsumer(consumer, config);
    }
}
