package ru.yandex.search.mail.yt.consumer.mobile.actions;

import java.io.File;

import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.search.mail.yt.consumer.SourceConsumer;
import ru.yandex.search.mail.yt.consumer.scheduler.AbstractScheduler;

public class MobileActionsScheduler extends AbstractScheduler {
    private static final int NAME_PARTS = 3;
    private static final DateTimeFormatter FORMATTER =
        ISODateTimeFormat.yearMonthDay();
    private static final long DEFAULT_START_TS = 0;

    public MobileActionsScheduler(final SourceConsumer consumer)
        throws ConfigException
    {
        super(consumer);
    }

    @Override
    protected long minimalTs() {
        return DEFAULT_START_TS;
    }

    @Override
    protected String extractName(final String name) {
        return new File(name).getName();
    }

    @Override
    protected DateTime accept(final String sourceName) {
        // expecting mobile.2018-03-21.index
        DateTime result = null;
        String[] split = sourceName.split("\\.");
        if (split.length == NAME_PARTS) {
            result = FORMATTER.parseDateTime(split[1]);
        }

        return result;
    }
}
