package ru.yandex.search.mail.yt.consumer.mobile.actions;

import java.util.logging.Level;

import ru.yandex.blackbox.BlackboxUserinfo;
import ru.yandex.search.mail.yt.consumer.upload.AbstractUploader;
import ru.yandex.search.mail.yt.consumer.upload.BasicJobContext;
import ru.yandex.search.mail.yt.consumer.upload.BasicQueueData;
import ru.yandex.search.mail.yt.consumer.upload.QueueAcceptor;
import ru.yandex.search.mail.yt.consumer.upload.ReadingYtClient;
import ru.yandex.search.mail.yt.consumer.upload.TskvReadingYtClient;
import ru.yandex.search.mail.yt.consumer.upload.Uploader;
import ru.yandex.search.mail.yt.consumer.upload.UploaderFactory;
import ru.yandex.tskv.TskvException;
import ru.yandex.tskv.TskvRecord;

public class MobileActionsUploaderFactory implements UploaderFactory {
    private static final int NUM_SHARDS = 65534;

    private final MobileActionsSourceConsumer consumer;

    public MobileActionsUploaderFactory(
        final MobileActionsSourceConsumer consumer)
    {
        this.consumer = consumer;
    }

    @Override
    public Uploader create(final BasicJobContext context) {
        return new MobileActionsUploader(context);
    }

    private final class MobileActionsUploader
        extends AbstractUploader<TskvRecord>
    {
        private final TskvReadingYtClient readingClient;

        private MobileActionsUploader(final BasicJobContext context) {
            super(consumer, context);

            this.readingClient =
                new TskvReadingYtClient(consumer.yt(), this);
        }

        @Override
        protected ReadingYtClient<TskvRecord> yt() {
            return readingClient;
        }

        @Override
        protected void parse(
            final TskvRecord record,
            final QueueAcceptor acceptor)
        {
            consumer.mobileTotal().accept(1);

            try {
                String data = record.getString("data");
                long uid = record.getLong("uid");
                long opTime = record.getLong("operation_time");
                String method = record.getString("method");
                String mdb = record.getString("mdb");

                StringBuilder uri = new StringBuilder("/");
                uri.append(method);
                uri.append("?service=");
                String service;
                if (BlackboxUserinfo.corp(uid)) {
                    service = "corp_change_log";
                } else {
                    service = "change_log";
                }
                uri.append(service);

                uri.append("&source=");
                uri.append("mobile_actions");
                uri.append("&mdb=");
                uri.append(mdb);
                uri.append("&path=");
                uri.append(context.source());
                uri.append("&tableOffset=");
                uri.append(context.offset());
                uri.append("&shard=");
                int shard = (int) (uid % NUM_SHARDS);
                uri.append(shard);
                uri.append("&prefix=");
                uri.append(uid);

                acceptor.add(
                    new BasicQueueData(
                        shard,
                        opTime,
                        uri.toString(),
                        data,
                        service));
            } catch (TskvException te) {
                context.logger().log(
                    Level.WARNING,
                    "Failed to parse record " + record,
                    te);
                consumer.mobileParseErrors().accept(1);
            }
        }

        @Override
        protected int batchSize() {
            return consumer.config().batchSize();
        }

        @Override
        protected int failureSendDelay() {
            return consumer.config().producerPushInterval();
        }
    }
}
