package ru.yandex.search.mail.yt.consumer.scheduler;

import org.apache.http.HttpHost;

import ru.yandex.json.writer.JsonType;

public abstract class AbstractSchedulerLock implements SchedulerLock {
    private final boolean master;
    private final long lockStartTime;
    private final long timeout;
    private final String lockId;
    private final HttpHost lockedHost;

    protected AbstractSchedulerLock(
        final boolean master,
        final long lockStartTime,
        final long timeout,
        final String lockId,
        final HttpHost lockedHost)
    {
        this.master = master;
        this.lockStartTime = lockStartTime;
        this.timeout = timeout;
        this.lockId = lockId;
        this.lockedHost = lockedHost;
    }

    @Override
    public boolean master() {
        return master;
    }

    @Override
    public boolean locked() {
        return this.leftAlive() > 0;
    }

    @Override
    public long lockStartTime() {
        return lockStartTime;
    }

    @Override
    public long timeout() {
        return timeout;
    }

    @Override
    public HttpHost lockedHost() {
        return lockedHost;
    }

    @Override
    public String lockId() {
        return lockId;
    }

    @Override
    public String toString() {
        return this.toString(JsonType.NORMAL);
    }
}
