package ru.yandex.search.mail.yt.consumer.scheduler;

import java.util.concurrent.atomic.AtomicReference;

import ru.yandex.tskv.TskvRecord;

public class Job {
    private final String id;
    private final String source;
    private final long offset;
    private final long length;
    private final long startTime;
    private final long finishTime;
    private final AtomicReference<JobStatus> status;

    public enum JobStatus {
        SCHEDULED,
        COMPLETING,
        COMPLETED,
        NOT_EXISTS
    }

    // CSOFF: ParameterNumber
    public Job(
        final String id,
        final String source,
        final JobStatus status,
        final long offset,
        final long length,
        final long startTime,
        final long finishTime)
    {
        this.id = id;
        this.source = source;
        this.status = new AtomicReference<>(status);
        this.offset = offset;
        this.length = length;
        this.startTime = startTime;
        this.finishTime = finishTime;
    }
    // CSON: ParameterNumber

    public String id() {
        return id;
    }

    public JobStatus status() {
        return status.get();
    }

    protected AtomicReference<JobStatus> statusRef() {
        return status;
    }

    public long startTime() {
        return startTime;
    }

    public long finishTime() {
        return finishTime;
    }

    public String source() {
        return source;
    }

    public long offset() {
        return offset;
    }

    public long length() {
        return length;
    }

    public TskvRecord toTskv() {
        TskvRecord record = new TskvRecord();
        record.put(SourceTask.JOBID, id);
        record.put(SourceTask.START_TIME, startTime);
        record.put(SourceTask.SOURCE, source);
        record.put(SourceTask.OFFSET, offset);
        record.put(SourceTask.LENGTH, length);
        record.put(SourceTask.FINISH_TIME, finishTime);
        record.put(SourceTask.STATUS, String.valueOf(status));
        return record;
    }
}
