package ru.yandex.search.mail.yt.consumer.scheduler;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;

import ru.yandex.json.async.consumer.AbstractJsonAsyncTypesafeDomConsumer;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.StringCollectorsFactory;

public class JobCompleteAsyncConsumer
    extends AbstractJsonAsyncTypesafeDomConsumer<Job.JobStatus>
{
    public JobCompleteAsyncConsumer(
        final HttpEntity entity)
        throws HttpException
    {
        super(
            entity,
            StringCollectorsFactory.INSTANCE,
            BasicContainerFactory.INSTANCE);
    }

    @Override
    protected Job.JobStatus buildResult(
        final HttpContext context,
        final JsonObject response)
        throws Exception
    {
        return response.asMap().getEnum(Job.JobStatus.class, "status");
    }
}
