package ru.yandex.search.mail.yt.consumer.scheduler;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;

import ru.yandex.http.util.HttpStatusPredicates;
import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.StatusCheckAsyncResponseConsumerFactory;

public class JobCompleteAsyncConsumerFactory
    implements HttpAsyncResponseConsumerFactory<Job.JobStatus>
{
    public static final StatusCheckAsyncResponseConsumerFactory<Job.JobStatus>
        OK = new StatusCheckAsyncResponseConsumerFactory<>(
        HttpStatusPredicates.OK,
        new JobCompleteAsyncConsumerFactory());

    @Override
    public HttpAsyncResponseConsumer<Job.JobStatus> create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException, IOException
    {
        return new JobCompleteAsyncConsumer(response.getEntity());
    }
}
