package ru.yandex.search.mail.yt.consumer.scheduler;

import java.io.IOException;

import org.apache.http.HttpHost;

import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonWriter;

public final class MissingLock implements SchedulerLock {
    public static final MissingLock INSTANCE = new MissingLock();

    private MissingLock() {
    }

    @Override
    public String lockId() {
        return null;
    }

    @Override
    public HttpHost lockedHost() {
        return null;
    }

    @Override
    public long lockStartTime() {
        return -1;
    }

    @Override
    public long timeout() {
        return -1;
    }

    @Override
    public boolean locked() {
        return false;
    }

    @Override
    public boolean master() {
        return false;
    }

    @Override
    public long leftAlive() {
        return -1;
    }

    @Override
    public String toString() {
        StringBuilderWriter sbw = new StringBuilderWriter();
        try (JsonWriter jw = JsonType.NORMAL.create(sbw)) {
            this.writeValue(jw);
        } catch (IOException ioe) {
        }

        return sbw.toString();
    }
}
