package ru.yandex.search.mail.yt.consumer.scheduler;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.function.GenericAutoCloseable;
import ru.yandex.logger.PrefixedLogger;

public interface Scheduler extends GenericAutoCloseable<IOException> {
    Future<Job.JobStatus> completeJob(
        final String jobId,
        final PrefixedLogger logger,
        final FutureCallback<Job.JobStatus> callback);

    SchedulerLock getMaster();

    Map<String, Object> status(boolean verbose);

    List<String> jobs();

    void start();
}
