package ru.yandex.search.mail.yt.consumer.scheduler;

import java.io.IOException;

import org.apache.http.HttpHost;

import ru.yandex.http.util.HttpHostParser;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;

public interface SchedulerLock extends JsonValue {
    String LOCKID = "lock_id";
    String LOCKED = "locked";
    String MASTER = "master";
    String STARTTIME = "started_at";
    String TIMEOUT = "timeout";
    String HOST = "host";

    String lockId();

    /**
     * locked host
     * @return
     */
    HttpHost lockedHost();

    long lockStartTime();

    long timeout();

    default long leftAlive() {
        return lockStartTime() + timeout() - System.currentTimeMillis();
    }

    /**
     * True if any of schedulers locked
     * @return
     */
    boolean locked();

    /**
     * True only if current host is master
     * @return
     */
    boolean master();

    @Override
    default void writeValue(final JsonWriterBase writer) throws IOException {
        writer.startObject();
        writer.key(MASTER);
        writer.value(master());
        writer.key(LOCKED);
        writer.value(locked());
        writer.key(LOCKID);
        writer.value(lockId());
        writer.key(STARTTIME);
        writer.value(lockStartTime());
        writer.key(TIMEOUT);
        writer.value(timeout());
        writer.key(HOST);
        writer.value(String.valueOf(lockedHost()));
        writer.endObject();
    }

    static SchedulerLock parse(final JsonObject obj) throws JsonException {
        JsonMap map = obj.asMap();
        map.getBoolean(MASTER);
        boolean locked = map.getBoolean(LOCKED);
        if (!locked) {
            return MissingLock.INSTANCE;
        }

        String lockId = map.getString(LOCKID);
        long timeout = map.getLong(TIMEOUT);
        long startTime = map.getLong(STARTTIME);
        HttpHost host = map.get(HOST, HttpHostParser.INSTANCE);

        return new SlaveLock(startTime, timeout, lockId, host);
    }

    default String toString(final JsonType type) {
        StringBuilderWriter sbw = new StringBuilderWriter();
        try (JsonWriterBase jw = type.create(sbw)) {
            this.writeValue(jw);
        } catch (IOException ioe) {
        }

        return sbw.toString();
    }
}
