package ru.yandex.search.mail.yt.consumer.upload;

import ru.yandex.search.mail.yt.consumer.QueueData;

public class BasicQueueData implements QueueData {
    private final int shard;
    private final double operationDate;

    private final String uri;
    private final String body;
    private final String service;

    // CSOFF: ParameterNumber
    public BasicQueueData(
        final int shard,
        final double operationDate,
        final String uri,
        final String body,
        final String service)
    {
        this.shard = shard;
        this.operationDate = operationDate;
        this.uri = uri;
        this.body = body;
        this.service = service;
    }
    // CSON: ParameterNumber

    @Override
    public int shard() {
        return shard;
    }

    @Override
    public double operationDate() {
        return operationDate;
    }

    @Override
    public String body() {
        return body;
    }

    @Override
    public String uri() {
        return uri;
    }

    @Override
    public String service() {
        return service;
    }
}
