package ru.yandex.search.mail.yt.consumer.upload;

import java.util.Locale;

import ru.yandex.logger.PrefixedLogger;
import ru.yandex.tskv.TskvRecord;

public interface JobContext {
    String JOB_ID = "id";
    String SOURCE = "source";
    String CONSUMER = "consumer";
    String OFFSET = "offset";
    String LENGTH = "length";
    String COMMIT_EVERY = "commit-interval";
    String SCHEDULER = "scheduler";

    PrefixedLogger logger();

    String source();

    int offset();

    int length();

    int commitEvery();

    String id();

    String workerFile();

    String completedPath();

    String malformedPath();

    String scheduler();

    SourceConsumerFactory consumer();

    default TskvRecord toTskv() {
        TskvRecord record = new TskvRecord();
        record.put(JOB_ID, id());
        record.put(SOURCE, source());
        record.put(OFFSET, offset());
        record.put(LENGTH, length());
        record.put(COMMIT_EVERY, commitEvery());
        record.put(
            CONSUMER,
            String.valueOf(consumer()).toLowerCase(Locale.ROOT));
        record.put(SCHEDULER, scheduler());
        return record;
    }
}
