package ru.yandex.search.mail.yt.consumer.upload;

import ru.yandex.logger.PrefixedLogger;
import ru.yandex.search.mail.yt.consumer.YtClient;
import ru.yandex.tskv.TskvException;
import ru.yandex.tskv.TskvRecord;

public class JobContextBuilder implements JobContext {
    private PrefixedLogger logger;

    private int offset = -1;
    private int length = -1;
    private int commitEvery;
    private String id = null;
    private String workerFile = null;
    private String completedPath = null;
    private String malformedPath = null;
    private String source = null;
    private String scheduler = null;
    private YtClient client;

    private SourceConsumerFactory consumer;

    public JobContextBuilder(
        final YtClient client,
        final PrefixedLogger logger)
    {
        this.logger = logger.addPrefix("NoJob");
        this.client = client;
    }

    @Override
    public String workerFile() {
        return workerFile;
    }

    public JobContextBuilder workerFile(
        final String workerFile)
    {
        this.workerFile = workerFile;
        return this;
    }

    @Override
    public String source() {
        return source;
    }

    public JobContextBuilder source(final String source) {
        this.source = source;
        return this;
    }

    @Override
    public int offset() {
        return offset;
    }

    public JobContextBuilder offset(final int offset) {
        this.offset = offset;
        return this;
    }

    @Override
    public int length() {
        return length;
    }

    public JobContextBuilder length(final int length) {
        this.length = length;
        return this;
    }

    private void updateLoggerPrefix() {
        if (id != null && consumer != null) {
            this.logger =
                this.logger.replacePrefix(consumer.name() + '-' + id);
        }
    }

    @Override
    public String id() {
        return id;
    }

    public JobContextBuilder id(final String id) {
        this.id = id;
        this.updateLoggerPrefix();

        return this;
    }

    @Override
    public PrefixedLogger logger() {
        return logger;
    }

    @Override
    public String completedPath() {
        return completedPath;
    }

    public JobContextBuilder completedPath(
        final String completedPath)
    {
        this.completedPath = completedPath;
        return this;
    }

    @Override
    public String malformedPath() {
        return malformedPath;
    }

    public JobContextBuilder malformedPath(
        final String malformedPath)
    {
        this.malformedPath = malformedPath;
        return this;
    }

    @Override
    public SourceConsumerFactory consumer() {
        return consumer;
    }

    public JobContextBuilder consumer(
        final SourceConsumerFactory consumerFactory)
    {
        this.consumer = consumerFactory;
        this.updateLoggerPrefix();
        return this;
    }

    @Override
    public String scheduler() {
        return scheduler;
    }

    public JobContextBuilder scheduler(final String scheduler) {
        this.scheduler = scheduler;
        return this;
    }

    public BasicJobContext build() {
        return new BasicJobContext(this, client, logger);
    }

    @Override
    public int commitEvery() {
        return commitEvery;
    }

    public JobContextBuilder commitEvery(final int commitEvery) {
        this.commitEvery = commitEvery;
        return this;
    }

    public static JobContextBuilder create(
        final YtClient client,
        final PrefixedLogger logger,
        final TskvRecord record)
        throws TskvException
    {
        JobContextBuilder builder = new JobContextBuilder(client, logger);
        builder.length(record.getInt(LENGTH));
        builder.offset(record.getInt(OFFSET));
        builder.source(record.get(SOURCE));
        builder.id(record.get(JOB_ID));
        builder.commitEvery(record.getInt(COMMIT_EVERY, -1));
        builder.scheduler(record.get(SCHEDULER));
        builder.consumer(
            record.getEnum(
                SourceConsumerFactory.class,
                CONSUMER));
        return builder;
    }
}
