package ru.yandex.search.mail.yt.consumer.upload;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.search.mail.yt.consumer.QueueData;

public class QueueAcceptor {
    protected final List<QueueData> queue;
    protected final int batchSize;
    protected int consumed;

    public QueueAcceptor(final int batchSize) {
        this.queue = new ArrayList<>(batchSize);
        this.batchSize = batchSize;
    }

    public void add(final QueueData data) {
        if (data != null) {
            this.queue.add(data);
        }

        this.consumed += 1;
    }

    public void add(final List<QueueData> data) {
        this.add(data, 1);
    }

    public void add(final List<QueueData> data, final int consumed) {
        this.queue.addAll(data);
        this.consumed += consumed;
    }

    protected void clear() {
        queue.clear();
        consumed = 0;
    }

    public List<QueueData> data() {
        return queue;
    }

    protected int size() {
        return queue.size();
    }

    protected boolean readyToFlush() {
        return queue.size() >= batchSize;
    }

    public int consumed() {
        return consumed;
    }
}
