package ru.yandex.search.mail.yt.consumer.upload;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.search.mail.yt.consumer.alice.AliceConsumerBuildContext;
import ru.yandex.search.mail.yt.consumer.config.SourceConsumerBuildContext;
import ru.yandex.search.mail.yt.consumer.mobile.actions.MobileActionsConsumerBuildContext;

public enum SourceConsumerFactory {
    ALICE {
        @Override
        public SourceConsumerBuildContext create(
            final IniConfig config)
            throws ConfigException
        {
            return new AliceConsumerBuildContext(config);
        }
    },
    MOBILE_ACTIONS {
        @Override
        public SourceConsumerBuildContext create(
            final IniConfig config)
            throws ConfigException
        {
            return new MobileActionsConsumerBuildContext(config);
        }
    };

    public abstract SourceConsumerBuildContext create(
        final IniConfig config)
        throws ConfigException;
}
