package ru.yandex.search.mail.yt.consumer.upload;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;

import org.apache.http.Header;
import org.apache.http.HttpHeaders;
import org.apache.http.message.BasicHeader;

import ru.yandex.http.util.EmptyFutureCallback;
import ru.yandex.http.util.HttpStatusPredicates;
import ru.yandex.http.util.nio.StatusCheckAsyncResponseConsumerFactory;
import ru.yandex.search.mail.yt.consumer.YtClient;
import ru.yandex.search.mail.yt.consumer.YtException;
import ru.yandex.tskv.TskvRecord;
import ru.yandex.tskv.TskvStreamAsyncConsumerFactory;

public class TskvReadingYtClient extends ReadingYtClient<TskvRecord> {
    private final StatusCheckAsyncResponseConsumerFactory<Void> consumerFactory;

    public TskvReadingYtClient(
        final YtClient yt,
        final Function<TskvRecord, Boolean> consumer)
    {
        super(yt);

        this.consumerFactory =
            new StatusCheckAsyncResponseConsumerFactory<>(
                HttpStatusPredicates.OK,
                new TskvStreamAsyncConsumerFactory(consumer));
    }

    @Override
    public void read(
        final String path,
        final int offset,
        final int length)
        throws InterruptedException, YtException
    {
        List<Header> headers = new ArrayList<>();
        headers.add(
            new BasicHeader(
                HttpHeaders.ACCEPT,
                "text/tab-separated-values"));

        if (length >= 0) {
            headers.add(
                new BasicHeader(
                    YtClient.YT_PARAMS_HEADER,
                    "{\"path\":{\"$value\":\"" + path
                        + "\",\"$attributes\":{\"ranges\":["
                        + "{\"lower_limit\":{\"row_index\":" + offset
                        + "}, \"upper_limit\":{\"row_index\":"
                        + (offset + length) + "}}]}}}"));
        }

        yt.logger().info(
            "Tskv Reading " + path + '[' + offset
                + ',' + (offset + length) + ']');
        try {
            yt.read(
                path,
                headers,
                consumerFactory,
                EmptyFutureCallback.INSTANCE).get();
        } catch (ExecutionException ee) {
            throw new YtException(ee);
        }
    }
}
