package ru.yandex.search.mail.yt.consumer.upload;

import ru.yandex.search.mail.yt.consumer.config.WorkersConfig;

public class UploadTask {
    private final String name;
    private final String lockedName;
    private final String todoPath;
    private final String completedPath;
    private final String processingPath;
    private final String malformedPath;

    public UploadTask(
        final String name,
        final String hostId,
        final WorkersConfig config)
    {
        this.name = name;
        this.lockedName = name + '.' + hostId;
        this.todoPath =
            config.todoPath() + '/' + name
                + UploadWorkersManager.READY_FOR_PROCESS;
        this.processingPath =
            config.processingPath() + '/' + lockedName
                + UploadWorkersManager.PROCESSING;
        this.completedPath =
            config.donePath() + '/' + name + UploadWorkersManager.COMPLETED;
        this.malformedPath =
            config.donePath() + '/' + name + UploadWorkersManager.MALFORMED;
    }

    public String name() {
        return name;
    }

    public String lockedName() {
        return lockedName;
    }

    public String todoPath() {
        return todoPath;
    }

    public String completedPath() {
        return completedPath;
    }

    public String processingPath() {
        return processingPath;
    }

    public String malformedPath() {
        return malformedPath;
    }

    @Override
    public String toString() {
        return "UploadTask{"
            + "name='" + name + '\''
            + ", lockedName='" + lockedName + '\''
            + ", todoPath='" + todoPath + '\''
            + ", completedPath='" + completedPath + '\''
            + ", processingPath='" + processingPath + '\''
            + ", malformedPath='" + malformedPath + '\''
            + '}';
    }
}
