package ru.yandex.search.mail.yt.consumer.yt;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.http.Header;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.TypesafeValueContentHandler;
import ru.yandex.json.parser.JsonException;

public class YtPath {
    private static final Pattern RANGE_PATTERN =
        Pattern.compile("\\[#(\\d+):#(\\d+)\\]");

    private final String path;
    private final int start;
    private final int end;

    public YtPath(final String path, final int start, final int end) {
        this.path = path;
        this.start = start;
        this.end = end;
    }

    public String path() {
        return path;
    }

    public int start() {
        return start;
    }

    public int end() {
        return end;
    }

    public static String toPath(final int start, final int end) {
        return "[#" + start + ":#" + end + ']';
    }

    public static YtPath fromHeader(
        final Header header)
        throws BadRequestException
    {
        try {
            final String rowIndex = "row_index";
            if (header != null && header.getValue() != null) {
                JsonObject root =
                    TypesafeValueContentHandler.parse(header.getValue());
                JsonMap pathMap = root.asMap().getMap("path");
                JsonMap ranges = pathMap.getMap("$attributes")
                    .getList("ranges").get(0).asMap();

                String path = pathMap.getString("$value");
                int left = ranges.getMap("lower_limit").getInt(rowIndex);
                int right = ranges.getMap("upper_limit").getInt(rowIndex);
                return new YtPath(path, left, right);
            }
        } catch (JsonException jbe) {
            throw new BadRequestException(jbe);
        }

        return null;
    }

    public static YtPath fromString(final String path) {
        Matcher rangeMatcher = RANGE_PATTERN.matcher(path);
        //parse range
        if (rangeMatcher.find()) {
            String basePath = path.substring(0, rangeMatcher.start());
            int leftRange = Integer.parseInt(rangeMatcher.group(1));
            int rightRange = Integer.parseInt(rangeMatcher.group(2));
            return new YtPath(basePath, leftRange, rightRange);
        }

        return new YtPath(path, 0, Integer.MAX_VALUE);
    }
}
