package ru.yandex.dispatcher.common;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.TimerTask;
import java.util.concurrent.Future;

import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpStatus;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.collection.IntPair;
import ru.yandex.concurrent.CompletedFuture;
import ru.yandex.concurrent.FailedFuture;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.util.timesource.TimeSource;

public class DelayShardMessage implements HttpMessage {
    private long delay;
    private long createTime;
    private long readTime;

    public DelayShardMessage() {
    }

    public DelayShardMessage(final long delay, final long createTime) {
        this.delay = delay;
        this.createTime = createTime;
        readTime = createTime;
    }

    @Override
    public String uri() {
        return null;
    }

    @Override
    public Future<IntPair<Void>> run(
        final HttpHost host,
        final AsyncClient client,
        final long queueId,
        final int shard,
        final String service,
        final String cgiParams)
    {
        try {
            Thread.sleep(delay);
        } catch (InterruptedException e) {
            return new FailedFuture<>(
                new IOException("Sleep was interrupted: " + e.getMessage()));
        }
        return new CompletedFuture<>(new IntPair<>(HttpStatus.SC_OK, null));
    }

    @Override
    public void run(
        final HttpHost host,
        final AsyncClient client,
        final long queueId,
        final int shard,
        final String service,
        final String cgiParams,
        final FutureCallback<IntPair<Void>> callback)
    {
        client.scheduleRetry(new DelayTask(callback), delay);
    }

    @Override
    public void setHeader(final String name, final String value) {
    }

    @Override
    public void deleteHeader(final String name) {
    }

    @Override
    public void copyHeadersFrom(final HttpRequest request) {
    }

    public long delay() {
        return delay;
    }

    @Override
    public boolean doWait() {
	return true;
    }

    @Override
    public long createTime() {
	return createTime;
    }

    @Override
    public long readTime() {
        return readTime;
    }

    @Override
    public void serialize(final DataOutputStream dout) throws IOException {
        dout.writeLong(delay);
        dout.writeLong(createTime);
    }

    @Override
    public void deserialize(final DataInputStream dis) throws IOException {
        delay = dis.readLong();
        createTime = dis.readLong();
        readTime = TimeSource.INSTANCE.currentTimeMillis();
    }

    @Override
    public byte[] toByteArray(
        final long queueId,
        final int shard,
        final String service)
    {
        return new byte[0];
    }

    @Override
    public String toString() {
        return "DelayShardMessage[delay=" + delay + ']';
    }

    private static class DelayTask extends TimerTask {
        private final FutureCallback<IntPair<Void>> callback;

        DelayTask(final FutureCallback<IntPair<Void>> callback) {
            this.callback = callback;
        }

        @Override
        public void run() {
            callback.completed(new IntPair<>(HttpStatus.SC_OK, null));
        }
    }
}

