package ru.yandex.dispatcher.common;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.collection.IntPair;
import ru.yandex.concurrent.CompletedFuture;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.util.timesource.TimeSource;

public class HangShardMessage implements HttpMessage {
    private long createTime;
    private long readTime;

    public HangShardMessage() {
    }

    public HangShardMessage(final long createTime) {
        this.createTime = createTime;
        readTime = createTime;
    }

    @Override
    public String uri() {
        return null;
    }

    @Override
    public CompletedFuture<IntPair<Void>> run(
        final HttpHost host,
        final AsyncClient client,
        final long queueId,
        final int shard,
        final String service,
        final String cgiParams)
    {
        return new CompletedFuture<>(new IntPair<>(0, null));
    }

    @Override
    public void run(
        final HttpHost host,
        final AsyncClient client,
        final long queueId,
        final int shard,
        final String service,
        final String cgiParams,
        final FutureCallback<IntPair<Void>> callback)
    {
    }

    @Override
    public void setHeader(final String name, final String value) {
    }

    @Override
    public void deleteHeader(final String name) {
    }

    @Override
    public void copyHeadersFrom(final HttpRequest request) {
    }

    @Override
    public boolean doWait() {
	return true;
    }

    @Override
    public long createTime() {
	return createTime;
    }

    @Override
    public long readTime() {
	return readTime;
    }

    @Override
    public void serialize(final DataOutputStream dout) throws IOException {
        dout.writeLong(createTime);
    }

    @Override
    public void deserialize(final DataInputStream dis) throws IOException {
        createTime = dis.readLong();
        readTime = TimeSource.INSTANCE.currentTimeMillis();
    }

    @Override
    public byte[] toByteArray(
        final long queueId,
        final int shard,
        final String service)
    {
        return new byte[0];
    }

    @Override
    public String toString() {
        return "HangShardMessage";
    }
}

