package ru.yandex.dispatcher.common;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;

import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncGetURIRequestProducerSupplier;
import ru.yandex.util.timesource.TimeSource;

public class HttpGetMessage extends AbstractHttpMessage {
    public HttpGetMessage() {
    }

    public HttpGetMessage(
        final String uri,
        final boolean doWait,
        final long createTime)
    {
        super(uri, doWait, createTime);
    }

    @Override
    protected BasicAsyncRequestProducerGenerator request(
        final String relativeUri)
    {
        return new BasicAsyncRequestProducerGenerator(relativeUri);
    }

    @Override
    protected Supplier<HttpAsyncRequestProducer> request(
        final URI absoluteUri)
    {
        return new AsyncGetURIRequestProducerSupplier(absoluteUri);
    }

    @Override
    public void serialize(final DataOutputStream dout) throws IOException {
        dout.writeUTF(uri);
        dout.writeBoolean(doWait);
        dout.writeLong(createTime);
        serializeHeaders(dout);
    }

    @Override
    public void deserialize(final DataInputStream dis) throws IOException {
        uri = dis.readUTF();
        doWait = dis.readBoolean();
        readTime = TimeSource.INSTANCE.currentTimeMillis();
        if (dis.available() > 0) {
            createTime = dis.readLong();
            deserializeHeaders(dis);
        }
    }

    @Override
    public byte[] toByteArray(
        final long queueId,
        final int shard,
        final String service)
    {
        StringBuilder sb = new StringBuilder();
        sb.append("GET ");
        sb.append(uri);
        sb.append(" HTTP/1.1\r\n");

        sb.append(YandexHeaders.ZOO_QUEUE_ID);
        sb.append(':');
        sb.append(' ');
        sb.append(queueId);
        sb.append('\r');
        sb.append('\n');

        sb.append(YandexHeaders.ZOO_SHARD_ID);
        sb.append(':');
        sb.append(' ');
        sb.append(shard);
        sb.append('\r');
        sb.append('\n');

        sb.append(YandexHeaders.ZOO_QUEUE);
        sb.append(':');
        sb.append(' ');
        sb.append(service);
        sb.append('\r');
        sb.append('\n');

        dumpHeaders(sb);
        sb.append("\r\n\r\n");
        return sb.toString().getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public String toString() {
        return "HttpGetMessage[wait=" + doWait + ']';
    }
}

