package ru.yandex.dispatcher.common;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import java.util.concurrent.Future;

import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.collection.IntPair;

import ru.yandex.http.util.nio.client.AsyncClient;

public interface HttpMessage {
    Future<IntPair<Void>> run(
        HttpHost host,
        AsyncClient client,
        long queueId,
        int shard,
        String service,
        String cgiParams);

    void run(
        HttpHost host,
        AsyncClient client,
        long queueId,
        int shard,
        String service,
        String cgiParams,
        FutureCallback<IntPair<Void>> callback);

    String uri();

    void setHeader(String name, String value);

    void deleteHeader(String name);

    void copyHeadersFrom(HttpRequest headers);

    void serialize(DataOutputStream dos) throws IOException;

    void deserialize(DataInputStream dis) throws IOException;

    boolean doWait();

    long createTime();

    long readTime();

    byte[] toByteArray(long queueId, int shard, String service);
}

