package ru.yandex.dispatcher.common;

import com.ning.compress.lzf.LZFEncoder;
import com.ning.compress.lzf.LZFDecoder;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SerializeUtils
{
    public static byte[] serializeHttpMessage( HttpMessage msg ) throws IOException
    {
        ByteArrayOutputStream baot = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream( baot );
        dos.writeUTF( msg.getClass().getName() );
        msg.serialize( dos );
        dos.close();
        return LZFEncoder.encode(baot.toByteArray());
    }

    public static HttpMessage deserializeHttpMessage( byte[] data ) throws IOException
    {
        ByteArrayInputStream bait = new ByteArrayInputStream( LZFDecoder.decode(data) );
        DataInputStream dis = new DataInputStream( bait );
        String className = dis.readUTF();
        try
        {
            Class<?> msgClass = Class.forName(className);
            HttpMessage msg = (HttpMessage)msgClass.newInstance();
            msg.deserialize( dis );
            dis.close();
            return msg;
        }
        catch( IllegalAccessException ie )
        {
            throw new IOException( "Message type is not supported: " + className, ie );
        }
        catch( ClassNotFoundException cnfe )
        {
            throw new IOException( "Message type is not supported: " + className, cnfe );
        }
        catch( InstantiationException ie )
        {
            throw new IOException( "Message type is not supported: " + className, ie );
        }
    }
}
