package ru.yandex.dispatcher.common;

import java.util.concurrent.atomic.AtomicBoolean;

public abstract class ZooDataCallbackBase<E> implements ZooDataCallback<E> {
    protected final AtomicBoolean fired = new AtomicBoolean(false);

    public abstract void dataImpl(E e);
    public abstract void dataChangedImpl();
    public abstract void errorImpl(ZooException e);

    @Override
    public void data(E e) {
        if (!fired.compareAndSet(false, true)) {
            return;
        }
        dataImpl(e);
    }

    @Override
    public void error(ZooException e) {
        if (!fired.compareAndSet(false, true)) {
            return;
        }
        errorImpl(e);
    }

    @Override
    public void dataChanged() {
        if (!fired.get()) {
            //no need to notify on data because previous request
            //is not finished yet
            return;
        }
        dataChangedImpl();
    }
}
