package ru.yandex.dispatcher.common;

import java.io.IOException;

import org.apache.zookeeper.KeeperException;

public class ZooException extends IOException {
    public ZooException(final String message) {
        super(message);
    }

    public ZooException(final Exception cause) {
        super(cause);
    }

    public ZooException(final String message, final Exception cause) {
        super(message, cause);
    }

    public static ZooException fromCode(final KeeperException.Code code,
        final String path)
    {
//        String message = "ZooKeeper exception for node <" + path + ">"
//            + KeeperException.create(code, path).getMessage();
        String message = KeeperException.create(code, path).getMessage();
        switch (code) {
            case CONNECTIONLOSS:
            case SESSIONEXPIRED:
            case SESSIONMOVED:
            case NOTREADONLY:
                return new ZooDisconnectedException(message);
            case NONODE:
                return new ZooNoNodeException(message);
            default:
                return new ZooException(message);
        }
    }
}
