package ru.yandex.dispatcher.common.connection;

import java.util.LinkedList;
import java.util.List;

import ru.yandex.dispatcher.consumer.ZooHost;

public class ZooConnectionDSN {

    private LinkedList<ZooHost> hosts;

    public ZooConnectionDSN(String connectString) {
        String[] a = connectString.split(",");
        hosts = new LinkedList<>();
        for(String addr : a) {
            final ZooHost zooHost = ZooHost.fromString(addr);
            hosts.add(zooHost);
        }
    }

    public List<ZooHost> hosts() {
        return hosts;
    }

    public int size() {
        return hosts.size();
    }

    public int port() {
        return hosts.get(0).port();
    }
}
