package ru.yandex.dispatcher.common.mappedvars;

import java.math.BigDecimal;

import ru.yandex.dispatcher.common.ZooException;
import ru.yandex.dispatcher.common.connection.ZooConnection;

public class ZooBigDecimalNode extends ZooNodeMapping {
    private BigDecimal value = null;

    public ZooBigDecimalNode(final ZooConnection conn, final String path) {
        super(conn, path);
    }

    protected void updateData(final byte[] data) {
        super.updateData(data);
        if (data != null) {
            String str = new String(data);
            value = new BigDecimal(str);
        } else {
            value = null;
        }
    }

    public BigDecimal value() throws ZooException {
        trySync();
        return value;
    }

    public BigDecimal cachedValue() {
        return value;
    }

    public void setCachedValue(final BigDecimal value) {
        this.value = value;
    }

    public void setValue(final BigDecimal value) throws ZooException {
        this.value = value;
        setData(value.toPlainString().getBytes());
    }
}
