package ru.yandex.dispatcher.common.mappedvars;

import ru.yandex.dispatcher.common.ZooException;
import ru.yandex.dispatcher.common.connection.ZooConnection;

public class ZooLongNode extends ZooNodeMapping {
    private Long value = null;

    public ZooLongNode(final ZooConnection conn, final String path) {
        super(conn, path);
    }

    protected void updateData(final byte[] data) {
        super.updateData(data);
        if (data != null) {
            String str = new String(data);
            value = Long.parseLong(str);
        } else {
            value = null;
        }
    }

    public Long longValue() throws ZooException {
        trySync();
        return value;
    }

    public Long longValueCached() {
        return value;
    }

    public void setLongValueCached(final long value) {
        this.value = value;
    }

    public void setLongValue(final long value) throws ZooException {
        this.value = value;
        setData(Long.toString(value).getBytes());
    }
}
