package ru.yandex.dispatcher.consumer;

import java.io.IOException;

import org.apache.http.protocol.HttpRequestHandler;

import ru.yandex.http.util.server.HttpServerFactory;
import ru.yandex.http.util.server.ImmutableBaseServerConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class ConsumerServerFactory
    implements HttpServerFactory<ImmutableBaseServerConfig, HttpRequestHandler>
{
    @Override
    public String name() {
        return "ru.yandex.dispatcher.consumer.ConsumerServer";
    }

    @Override
    public ConsumerServer create(final IniConfig config)
        throws ConfigException, IOException
    {
        System.setProperty("jute.maxbuffer", "64000000");
        try {
            return new ConsumerServer(config);
        } catch (ConfigException e) {
            throw e;
        } catch (IOException e) {
            throw e;
        } catch (Exception e) {
            throw new ConfigException("Failed to create consumer", e);
        }
    }
}

