package ru.yandex.dispatcher.consumer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import java.text.ParseException;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public enum HostnameResolverType implements HostnameResolver {
    SYSTEM_CMD {
        String shell;
        String shellArgs;
        String sysCmd;

        @Override
        public void init(IniConfig config) throws ConfigException {
            this.config = config.section("system_cmd_resolver");
            shell = this.config.getString("shell", "/bin/sh");
            shellArgs = this.config.getString("shell_args", "-c");
            sysCmd = this.config.getString("cmd", "hostname -f");
        }

        @Override
        public String resolve() throws ParseException, IOException {
            Process process =
                new ProcessBuilder(shell, shellArgs, sysCmd).start();
            InputStream is = process.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            try {
                String line = br.readLine();
                if (line == null) {
                    throw new ParseException("System cmd returned an empty output", 0);
                }
                return line.trim();
            } finally {
                br.close();
                is.close();
            }
        }
    },
    STATIC {
        String hostname;

        @Override
        public void init(IniConfig config) throws ConfigException {
            this.config = config.section("static_resolver");
            hostname = this.config.getString("hostname");
        }

        @Override
        public String resolve() throws ParseException {
            return hostname;
        }
    };

    IniConfig config;
    public abstract void init(IniConfig config) throws ConfigException;

    @Override
    public abstract String resolve() throws ParseException, IOException;
}
