package ru.yandex.dispatcher.consumer;

import java.io.IOException;

import java.util.ArrayList;
import java.util.List;

import java.util.logging.Level;
import java.util.logging.Logger;

import org.apache.http.HttpHost;

import ru.yandex.dispatcher.consumer.shard.Shard;

import ru.yandex.http.config.ImmutableHttpTargetConfig;

import ru.yandex.parser.uri.ScanningCgiParams;

public class KamajiAsyncConsumer extends AsyncConsumer {
    public KamajiAsyncConsumer(
        final HttpHost host,
        final HttpHost queueIdHost,
        final String service,
        final int workers,
        final ConsumerServer server,
        final ImmutableHttpTargetConfig targetConfig,
        final List<String> primaryKeyFields,
        final boolean groupNullKeys,
        final boolean queueIdHeader,
        final int maxRetryCount,
        final List<String> deduplicationKeyFields,
        final boolean ignoreBackendPosition,
        final BackendCommitPolicy commitPolicy,
        final long watchdogDelay,
        final boolean zeroTolerance,
        final long rateLimitDelay)
    {
        super(
            host,
            queueIdHost,
            service,
            workers,
            server,
            targetConfig,
            primaryKeyFields,
            groupNullKeys,
            queueIdHeader,
            maxRetryCount,
            deduplicationKeyFields,
            ignoreBackendPosition,
            commitPolicy,
            watchdogDelay,
            zeroTolerance,
            rateLimitDelay);
    }

    private boolean isStore(final String uri) {
        if (uri != null) {
            final String changeType =
                new ScanningCgiParams(uri).getString("change-type", null);
            if ("store".equals(changeType)
                || "sync-store".equals(changeType))
            {
                return true;
            }
        }
        return false;
    }

    @Override
    protected List<List<Node>> groups(final List<Node> nodes, final Shard shard)
        throws IOException
    {
        final Logger logger = shard.logger();
        final List<List<Node>> groups = super.groups(nodes, shard);
        final List<List<Node>> newGroups = new ArrayList<>(groups.size());
        List<Node> currentGroup = new ArrayList<>(1);
        for (List<Node> oldNodes: groups) {
            if (oldNodes.size() == 1 && isStore(oldNodes.get(0).msg.uri())) {
                currentGroup.add(oldNodes.get(0));
            } else {
                if (!currentGroup.isEmpty()) {
                    newGroups.add(currentGroup);
                    currentGroup = new ArrayList<>(1);
                }
                newGroups.add(oldNodes);
            }
        }
        if (!currentGroup.isEmpty()) {
            newGroups.add(currentGroup);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(
                groups.size() + " groups repacked into "
                    + newGroups.size() + " groups");
        }
        return newGroups;
    }
}
