package ru.yandex.dispatcher.consumer;

import ru.yandex.dispatcher.common.HttpMessage;
import ru.yandex.dispatcher.consumer.shard.Shard;

public class Node {
    public final String path;
    public final long seq;
    public final Shard shard;
    public final boolean notifyStatus;
    public int retryCount = 0;
    public byte[] data;
    public HttpMessage msg;

    public Node(
        final String path,
        final long seq,
        final Shard shard,
        final boolean notifyStatus,
        final byte[] data)
    {
        this.path = path;
        this.seq = seq;
        this.shard = shard;
        this.notifyStatus = notifyStatus;
        this.data = data;
    }

    @Override
    public String toString() {
        return "seq=" + seq + ", notify=" + notifyStatus + ", shard="
            + shard.shardNo;
    }
}

