package ru.yandex.dispatcher.consumer;

import java.io.IOException;

import org.apache.http.concurrent.FutureCallback;
import ru.yandex.http.util.EmptyFutureCallback;

public interface ShardsPositions {
    long getPosition(int shard) throws IOException;

    void updatePosition(
        final int shard,
        final long position,
        final FutureCallback<Object> callback);

    default void updatePosition(int shard, long position) {
        updatePosition(shard, position, EmptyFutureCallback.INSTANCE);
    }
}
