package ru.yandex.dispatcher.consumer;

import java.util.HashMap;

import org.apache.http.HttpHost;

public class ZooHost {
    private static final HashMap<String, ZooHost> INTERNER = new HashMap<>();

    private final String zkEntry;
    private final String zkAddress;
    private final HttpHost httpHost;
    private final int port;

    private ZooHost(final String zkEntry) {
        this.zkEntry = zkEntry;

        final int colon = zkEntry.lastIndexOf(':');
        final String hostname = zkEntry.substring(0, colon);
        final String ports = zkEntry.substring(colon + 1);
        final int slash = ports.lastIndexOf('/');
        final int httpPort;
        if (slash == -1) {
            zkAddress = zkEntry;
            port = Integer.parseInt(ports);
            httpPort = Integer.parseInt("8" + ports.substring(1));
        } else {
            port = Integer.parseInt(ports.substring(0, slash));
            zkAddress = hostname + ':' + ports.substring(0, slash);
            httpPort = Integer.parseInt(ports.substring(slash + 1));
        }
        httpHost = new HttpHost(hostname, httpPort);
    }

    public static ZooHost fromString(final String zkEntry) {
        synchronized(INTERNER) {
            ZooHost zooHost = INTERNER.get(zkEntry);
            if (zooHost == null) {
                zooHost = new ZooHost(zkEntry);
                INTERNER.put(zkEntry, zooHost);
            }
            return zooHost;
        }
    }

    @Override
    public String toString() {
        return zkEntry;
    }

    public String zkAddress() {
        return zkAddress;
    }

    public HttpHost httpHost() {
        return httpHost;
    }

    public int port() {
        return port;
    }

    @Override
    public int hashCode() {
        return zkEntry.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return o == this;
    }
}
