package ru.yandex.dispatcher.consumer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;

import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.logger.PrefixedLogger;

public class ZooKeeperDSN {
    private final LinkedList<ZooHost> hosts = new LinkedList<>();
    private final AsyncClient asyncClient;
    private final int hostCount;
    private ZooHost currentHost;

    public ZooKeeperDSN(
        final String connectString,
        final PrefixedLogger logger,
        final AsyncClient asyncClient)
    {
        this.asyncClient = asyncClient;
        final String[] a = connectString.split(",");
        hostCount = a.length;
        for (String addr : a) {
            final ZooHost zooHost = ZooHost.fromString(addr);
            hosts.add(zooHost);
            isAlive(zooHost, logger);
        }
        Collections.shuffle(hosts);
        nextHost();
    }

    public boolean isAlive(final ZooHost host, final PrefixedLogger logger) {
        return ZooKeeperPool.isAlive(host, logger, asyncClient);
    }

    public synchronized ArrayList<ZooHost> hosts() {
        return new ArrayList<>(hosts);
    }

    public synchronized ZooHost nextHost() {
        currentHost = hosts.removeFirst();
        hosts.add(currentHost);
        return currentHost;
    }

    public synchronized ZooHost currentHost() {
        return currentHost;
    }

    public synchronized void setCurrentHost(final ZooHost host) {
        while (!currentHost.equals(host)) {
            nextHost();
        }
    }

    public int hostCount() {
        return hostCount;
    }
}
