package ru.yandex.dispatcher.consumer.config;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import ru.yandex.parser.config.ConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractConsumerConfigBuilder
    <T extends AbstractConsumerConfigBuilder<T>>
    implements ConfigBuilder<T>, ConsumerConfig
{
    private Set<String> consumerTags;
    private int workers;
    private int timeout;
    private long watchdogDelay;
    private long readStatusDelay;
    private int nextIdFinderMinHostCountPct;
    private int advanceOnMissed;
    private Set<String> ignorePosition;
    private boolean responseless;
    private long sleepInterval;
    private int prefetchCount;
    private long statusGroupingTime;
    private List<String> producers;

    protected AbstractConsumerConfigBuilder(final ConsumerConfig config) {
        consumerTags(config.consumerTags());
        workers(config.workers());
        timeout(config.timeout());
        watchdogDelay(config.watchdogDelay());
        readStatusDelay(config.readStatusDelay());
        nextIdFinderMinHostCountPct(config.nextIdFinderMinHostCountPct());
        advanceOnMissed(config.advanceOnMissed());
        ignorePosition(config.ignorePosition());
        responseless(config.responseless());
        sleepInterval(config.sleepInterval());
        prefetchCount(config.prefetchCount());
        statusGroupingTime(config.statusGroupingTime());
        producers(config.producers());
    }

    protected AbstractConsumerConfigBuilder(
        final IniConfig config,
        final ConsumerConfig defaults)
        throws ConfigException
    {
        consumerTags = CONSUMER_TAGS.extract(config, defaults.consumerTags());
        workers = WORKERS.extract(config, defaults.workers());
        timeout = TIMEOUT.extract(config, defaults.timeout());
        watchdogDelay =
            WATCHDOG_DELAY.extract(config, defaults.watchdogDelay());
        readStatusDelay =
            READ_STATUS_DELAY.extract(config, defaults.readStatusDelay());
        nextIdFinderMinHostCountPct =
            NEXT_ID_FINDER_MIN_HOST_COUNT_PCT.extract(
                config,
                defaults.nextIdFinderMinHostCountPct());
        advanceOnMissed =
            ADVANCE_ON_MISSED.extract(config, defaults.advanceOnMissed());
        ignorePosition =
            IGNORE_POSITION.extract(config, defaults.ignorePosition());
        responseless = RESPONSELESS.extract(config, defaults.responseless());
        sleepInterval =
            SLEEP_INTERVAL.extract(config, defaults.sleepInterval());
        prefetchCount =
            PREFETCH_COUNT.extract(config, defaults.prefetchCount());
        statusGroupingTime =
            STATUS_GROUPING_TIME.extract(
                config,
                defaults.statusGroupingTime());
        producers = PRODUCERS.extract(config, defaults.producers());
    }

    @Override
    public Set<String> consumerTags() {
        return consumerTags;
    }

    public T consumerTags(final Set<String> consumerTags) {
        this.consumerTags = new HashSet<>(consumerTags);
        return self();
    }

    @Override
    public int workers() {
        return workers;
    }

    public T workers(final int workers) {
        this.workers = workers;
        return self();
    }

    @Override
    public int timeout() {
        return timeout;
    }

    public T timeout(final int timeout) {
        this.timeout = timeout;
        return self();
    }

    @Override
    public long watchdogDelay() {
        return watchdogDelay;
    }

    public T watchdogDelay(final long watchdogDelay) {
        this.watchdogDelay = watchdogDelay;
        return self();
    }

    @Override
    public long readStatusDelay() {
        return readStatusDelay;
    }

    public T readStatusDelay(final long readStatusDelay) {
        this.readStatusDelay = readStatusDelay;
        return self();
    }

    @Override
    public int nextIdFinderMinHostCountPct() {
        return nextIdFinderMinHostCountPct;
    }

    public T nextIdFinderMinHostCountPct(
        final int nextIdFinderMinHostCountPct)
    {
        this.nextIdFinderMinHostCountPct = nextIdFinderMinHostCountPct;
        return self();
    }

    @Override
    public int advanceOnMissed() {
        return advanceOnMissed;
    }

    public T advanceOnMissed(final int advanceOnMissed) {
        this.advanceOnMissed = advanceOnMissed;
        return self();
    }

    @Override
    public Set<String> ignorePosition() {
        return ignorePosition;
    }

    public T ignorePosition(final Set<String> ignorePosition) {
        this.ignorePosition = new HashSet<>(ignorePosition);
        return self();
    }

    @Override
    public boolean responseless() {
        return responseless;
    }

    public T responseless(final boolean responseless) {
        this.responseless = responseless;
        return self();
    }

    @Override
    public long sleepInterval() {
        return sleepInterval;
    }

    public T sleepInterval(final long sleepInterval) {
        this.sleepInterval = sleepInterval;
        return self();
    }

    @Override
    public int prefetchCount() {
        return prefetchCount;
    }

    public T prefetchCount(final int prefetchCount) {
        this.prefetchCount = prefetchCount;
        return self();
    }

    @Override
    public long statusGroupingTime() {
        return statusGroupingTime;
    }

    public T statusGroupingTime(final long statusGroupingTime) {
        this.statusGroupingTime = statusGroupingTime;
        return self();
    }

    @Override
    public List<String> producers() {
        return producers;
    }

    public T producers(final List<String> producers) {
        this.producers = new ArrayList<>(producers);
        return self();
    }
}

