package ru.yandex.dispatcher.consumer.config;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import ru.yandex.function.GenericFunction;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.BooleanParser;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.string.DoubleToIntegerValidator;
import ru.yandex.parser.string.DoubleToLongValidator;
import ru.yandex.parser.string.DurationParser;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.NonNegativeValidator;
import ru.yandex.parser.string.PositiveValidator;

public interface ConsumerConfig {
    ParameterConfig<Set<String>> CONSUMER_TAGS =
        new ParameterConfig<>(
            "consumer-tags",
            new CollectionParser<>(NonEmptyValidator.TRIMMED, HashSet::new),
            GenericFunction.identity());
    ParameterConfig<Integer> WORKERS =
        new ParameterConfig<>(
            "workers",
            Integer::valueOf,
            PositiveValidator.instance());
    ParameterConfig<Integer> TIMEOUT =
        new ParameterConfig<>(
            "timeout",
            DurationParser.INSTANCE.andThen(DoubleToIntegerValidator.INSTANCE),
            NonNegativeValidator.instance());
    ParameterConfig<Long> WATCHDOG_DELAY =
        new ParameterConfig<>(
            "watchdog-delay",
            DurationParser.INSTANCE.andThen(DoubleToLongValidator.INSTANCE),
            PositiveValidator.instance());
    ParameterConfig<Long> READ_STATUS_DELAY =
        new ParameterConfig<>(
            "read-status-delay",
            DurationParser.INSTANCE.andThen(DoubleToLongValidator.INSTANCE),
            PositiveValidator.instance());
    ParameterConfig<Integer> NEXT_ID_FINDER_MIN_HOST_COUNT_PCT =
        new ParameterConfig<>(
            "next-id-finder-min-host-count-pct",
            Integer::valueOf,
            PositiveValidator.instance());
    ParameterConfig<Integer> ADVANCE_ON_MISSED =
        new ParameterConfig<>(
            "advance_on_missed",
            Integer::valueOf,
            NonNegativeValidator.instance());
    ParameterConfig<Set<String>> IGNORE_POSITION =
        new ParameterConfig<>(
            "ignore_position",
            new CollectionParser<>(NonEmptyValidator.TRIMMED, HashSet::new),
            GenericFunction.identity());
    ParameterConfig<Boolean> RESPONSELESS =
        new ParameterConfig<>(
            "responseless",
            BooleanParser.INSTANCE,
            GenericFunction.identity());
    ParameterConfig<Long> SLEEP_INTERVAL =
        new ParameterConfig<>(
            "sleep-interval",
            DurationParser.INSTANCE.andThen(DoubleToLongValidator.INSTANCE),
            PositiveValidator.instance());
    ParameterConfig<Integer> PREFETCH_COUNT =
        new ParameterConfig<>(
            "prefetch-count",
            Integer::valueOf,
            PositiveValidator.instance());
    ParameterConfig<Long> STATUS_GROUPING_TIME =
        new ParameterConfig<>(
            "status-grouping-time",
            Long::valueOf,
            PositiveValidator.instance());
    ParameterConfig<List<String>> PRODUCERS =
        new ParameterConfig<>(
            "producers",
            new CollectionParser<>(NonEmptyValidator.TRIMMED, ArrayList::new),
            GenericFunction.identity());

    Set<String> consumerTags();

    int workers();

    int timeout();

    long watchdogDelay();

    long readStatusDelay();

    int nextIdFinderMinHostCountPct();

    int advanceOnMissed();

    Set<String> ignorePosition();

    boolean responseless();

    long sleepInterval();

    int prefetchCount();

    long statusGroupingTime();

    List<String> producers();
}

