package ru.yandex.dispatcher.consumer.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class ConsumerConfigBuilder
    extends AbstractConsumerConfigBuilder<ConsumerConfigBuilder>
{
    public ConsumerConfigBuilder() {
        super(ConsumerConfigDefaults.INSTANCE);
    }

    public ConsumerConfigBuilder(final ConsumerConfig config) {
        super(config);
    }

    public ConsumerConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, ConsumerConfigDefaults.INSTANCE);
    }

    public ConsumerConfigBuilder(
        final IniConfig config,
        final ConsumerConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public ConsumerConfigBuilder self() {
        return this;
    }

    public ImmutableConsumerConfig build() throws ConfigException {
        return new ImmutableConsumerConfig(this);
    }
}

