package ru.yandex.dispatcher.consumer.config;

import java.util.Collections;
import java.util.List;
import java.util.Set;

import ru.yandex.dispatcher.consumer.shard.Shard;

public class ConsumerConfigDefaults implements ConsumerConfig {
    public static final ConsumerConfigDefaults INSTANCE =
        new ConsumerConfigDefaults();

    protected ConsumerConfigDefaults() {
    }

    @Override
    public Set<String> consumerTags() {
        return Collections.emptySet();
    }

    @Override
    public int workers() {
        return 10;
    }

    @Override
    public int timeout() {
        return 40;
    }

    @Override
    public long watchdogDelay() {
        return Shard.WATCHDOG_DELAY;
    }

    @Override
    public long readStatusDelay() {
        return Shard.READ_STATUS_DELAY;
    }

    @Override
    public int nextIdFinderMinHostCountPct() {
        return 51;
    }

    @Override
    public int advanceOnMissed() {
        return 0;
    }

    @Override
    public Set<String> ignorePosition() {
        return Collections.emptySet();
    }

    @Override
    public boolean responseless() {
        return false;
    }

    @Override
    public long sleepInterval() {
        return 1000L;
    }

    @Override
    public int prefetchCount() {
        return 10;
    }

    @Override
    public long statusGroupingTime() {
        return 10000L;
    }

    @Override
    public List<String> producers() {
        return Collections.emptyList();
    }
}

