package ru.yandex.dispatcher.consumer.config;

import java.util.List;
import java.util.Set;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.ImmutableConfig;

public class ImmutableConsumerConfig
    implements ImmutableConfig, ConsumerConfig
{
    private final Set<String> consumerTags;
    private final int workers;
    private final int timeout;
    private final long watchdogDelay;
    private final long readStatusDelay;
    private final int nextIdFinderMinHostCountPct;
    private final int advanceOnMissed;
    private final Set<String> ignorePosition;
    private final boolean responseless;
    private final long sleepInterval;
    private final int prefetchCount;
    private final long statusGroupingTime;
    private final List<String> producers;

    public ImmutableConsumerConfig(final ConsumerConfig config)
        throws ConfigException
    {
        consumerTags = CONSUMER_TAGS.validate(config.consumerTags());
        workers = WORKERS.validate(config.workers());
        timeout = TIMEOUT.validate(config.timeout());
        watchdogDelay = WATCHDOG_DELAY.validate(config.watchdogDelay());
        readStatusDelay = READ_STATUS_DELAY.validate(config.readStatusDelay());
        nextIdFinderMinHostCountPct =
            NEXT_ID_FINDER_MIN_HOST_COUNT_PCT.validate(
                config.nextIdFinderMinHostCountPct());
        advanceOnMissed = ADVANCE_ON_MISSED.validate(config.advanceOnMissed());
        ignorePosition = IGNORE_POSITION.validate(config.ignorePosition());
        responseless = RESPONSELESS.validate(config.responseless());
        sleepInterval = SLEEP_INTERVAL.validate(config.sleepInterval());
        prefetchCount = PREFETCH_COUNT.validate(config.prefetchCount());
        statusGroupingTime =
            STATUS_GROUPING_TIME.validate(config.statusGroupingTime());
        producers = PRODUCERS.validate(config.producers());
    }

    @Override
    public Set<String> consumerTags() {
        return consumerTags;
    }

    @Override
    public int workers() {
        return workers;
    }

    @Override
    public int timeout() {
        return timeout;
    }

    @Override
    public long watchdogDelay() {
        return watchdogDelay;
    }

    @Override
    public long readStatusDelay() {
        return readStatusDelay;
    }

    @Override
    public int nextIdFinderMinHostCountPct() {
        return nextIdFinderMinHostCountPct;
    }

    @Override
    public int advanceOnMissed() {
        return advanceOnMissed;
    }

    @Override
    public Set<String> ignorePosition() {
        return ignorePosition;
    }

    @Override
    public boolean responseless() {
        return responseless;
    }

    @Override
    public long sleepInterval() {
        return sleepInterval;
    }

    @Override
    public int prefetchCount() {
        return prefetchCount;
    }

    @Override
    public long statusGroupingTime() {
        return statusGroupingTime;
    }

    @Override
    public List<String> producers() {
        return producers;
    }
}

