package ru.yandex.dispatcher.consumer.lock;

import java.util.logging.Level;

import ru.yandex.dispatcher.common.ZooException;
import ru.yandex.dispatcher.common.connection.ZooConnection;
import ru.yandex.dispatcher.common.connection.ZooConnectionDSN;
import ru.yandex.dispatcher.common.mappedvars.ZooLock;
import ru.yandex.dispatcher.common.mappedvars.UnparkCallback;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.logger.PrefixedLogger;

public class PerConsumerQueueLock implements QueueLock {
    private final static int DEFAULT_TIMEOUT = 30000;

    private final String zk;
    private final ZooConnectionDSN dsn;
    private final ZooConnection conn;
    private final ZooLock lock;
    private final PrefixedLogger logger;

    public PerConsumerQueueLock(
        final AsyncClient httpClient,
        final String zk,
        final String service,
        final String name,
        final PrefixedLogger logger)
    {
        this.zk = zk;
        this.logger = logger;
        dsn = new ZooConnectionDSN(zk);
        conn =
            ZooConnection.createConnection(
                httpClient,
                dsn,
                DEFAULT_TIMEOUT,
                true,
                logger);
        conn.connectAsync();
        lock = new ZooLock(conn, '/' + service + "/consumer_lock_" + name,
            DEFAULT_TIMEOUT);
        lock.setLogger(logger);
    }

    public boolean tryLock(int shard) {
        try {
            return lock.isLockedNonBlock();
        } catch (ZooException e) {
            logger.log(Level.SEVERE, "PerConsumerQueueLock.tryLock error", e);
            return false;
        }
    }

    public void park(int shard, UnparkCallback uc) {
        lock.park(uc);
    }
}
