package ru.yandex.dispatcher.consumer.logstore;

import java.io.File;
import java.io.IOException;

import ru.yandex.dispatcher.common.HttpMessage;

public class LogStore {

public static final int MSGS_PER_FILE = 100000;
public static final int MAGIC = 65535;
private final String path;
private ShardStore[] shards;
private final String service;

    public LogStore(
        final String path,
        final String service)
        throws IOException
    {
        this.path = path;
        this.service = service;
        init(path);
    }

    private void init(String path) throws IOException {
        File root = new File(path);
        if (root.exists()) {
            if (!root.isDirectory()) {
                throw new IOException("LogStore path <" + path + "> is not a directory");
            }
        } else {
            if (!root.mkdirs()) {
                throw new IOException("Can't create LogStore directory <" + path + "> ");
            }
        }
        shards = new ShardStore[MAGIC];
        for (int i = 0; i < MAGIC; i++) {
            shards[i] = new ShardStore(
                path + "_lowsharding/" + (int)(i / 1000),
                i,
                service);
        }
    }

    public void putMessage(int shard, long seq, HttpMessage msg) throws IOException {
        shards[shard].putMessage(seq, msg);
    }

    public long getShardPosition(int shard) {
        return shards[shard].getPos();
    }

    public void setShardPosition(int shard, long pos) throws IOException {
        shards[shard].setPos(pos);
    }
}
