package ru.yandex.dispatcher.consumer.logstore;

import java.io.IOException;
import java.io.RandomAccessFile;

public class ShardPos {
    private final String path;
    private final RandomAccessFile raf;
    private long currentPosition;

    public ShardPos(final String path) throws IOException {
        this.path = path;
        raf = new RandomAccessFile(path, "rw");
        if (raf.length() == 0) {
            setPos(-1);
        } else {
            raf.seek(0);
            byte[] posBytes = new byte[(int)raf.length()];
            raf.readFully(posBytes);
            String pos = new String(posBytes);
            currentPosition = Long.parseLong(pos);
            if (currentPosition < -1) {
                throw new IOException("Corrupted shard position file: pos = "
                    + currentPosition);
            }
        }
    }

    public synchronized void setPos(long pos) throws IOException {
        raf.seek(0);
        byte[] posBytes = Long.toString(pos).getBytes();
        raf.write(posBytes);
        raf.setLength(posBytes.length);
        currentPosition = pos;
    }

    public synchronized long getPos() {
        return currentPosition;
    }

    public void close() throws IOException {
        raf.close();
    }
}
