package ru.yandex.dispatcher.consumer.shard;

import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import java.util.logging.Level;
import java.util.logging.Logger;

import ru.yandex.concurrent.NamedThreadFactory;

public class Delayer {
    private static final ScheduledThreadPoolExecutor executor =
        createExecutor();

    private static ScheduledThreadPoolExecutor createExecutor() {
        final ScheduledThreadPoolExecutor executor =
            new ScheduledThreadPoolExecutor(
                2,
                new NamedThreadFactory("Delayer-"));
        executor.setRemoveOnCancelPolicy(true);
        return executor;
    }

    public static Future schedule(final Runnable task, final long millis) {
        final Runnable realTask;
        if (task instanceof ShardTask) {
            realTask = new Runnable() {
                @Override
                public void run() {
                    final Shard shard = ((ShardTask) task).shard();
                    synchronized(shard) {
                        if (!((ShardTask) task).checkOper()) {
                            if (shard.logger().isLoggable(Level.FINE)) {
                                shard.logger().fine("Dropping delayed task: "
                                    + task + ": operId missmatch");
                            }
                            return;
                        }
                        task.run();
                    }
                }
            };
        } else {
            realTask = task;
        }
        try {
            return executor.schedule(realTask, millis, TimeUnit.MILLISECONDS);
        } catch (Exception e) {
            FutureTask<?> f = new FutureTask<Void>(realTask, null);
            f.run();
            return f;
        }
    }
}
