package ru.yandex.dispatcher.consumer.shard;

import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ShardTask implements Runnable {
    protected final Shard shard;
    protected final Logger logger;
    protected volatile long operId;

    public ShardTask(final Shard shard) {
        this(shard, 0L);
    }

    public ShardTask(final Shard shard, final long operId) {
        this.shard = shard;
        this.operId = operId;
        logger = shard.logger();
    }

    @Override
    public abstract void run();

    protected boolean checkOper() {
        boolean res = operId == shard.currentOperId();
        if (!res && logger.isLoggable(Level.FINE)) {
            StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
            StringBuilder message =
                new StringBuilder("checkOper failed for operId = ");
            message.append(operId);
            message.append(" while currentId = ");
            message.append(shard.currentOperId());
            for (int i = 2; i <= Math.min(4, stacktrace.length); ++i) {
                message.append(" at ");
                message.append(stacktrace[i]);
            }
            logger.fine(new String(message));
        }
        return res;
    }

    protected void initOperId() {
        operId = shard.nextOperId();
    }

    public long operId() {
        return operId;
    }

    public Shard shard() {
        return shard;
    }

    protected void reset() {
        shard.reset();
    }

}
