package ru.yandex.dispatcher.consumer.shard;

import java.util.logging.Level;

import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.Watcher.Event.KeeperState;
import org.apache.zookeeper.data.Stat;

public class StatusNodeWaiter extends ShardTask
    implements AsyncCallback.StatCallback, Watcher
{
    public StatusNodeWaiter(final Shard shard) {
        super(shard);
    }

    @Override
    public void run() {
        synchronized(shard) {
            initOperId();
            waitFor(shard.statusPath());
        }
    }

    public void waitFor(final String path) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("StatusNodeWaiter.waitFor<" + path + ">: oper="
                + operId);
        }
        ZooKeeper zk = shard.getZk();
        zk.exists(path, this, this, null);
    }

    //GetData handler
    @Override
    public void processResult(final int rc, final String path, final Object ctx,
        final Stat stat)
    {
        synchronized(shard) {
            if (!checkOper()) return;
            if (rc == 0) {
                if (!shard.statusPath().equals(path)) {
                    if (logger.isLoggable(Level.SEVERE)) {
                        logger.severe("StatusNodeWaiter.waitFor<" +
                            shard.statusPath() +
                            ">: unhandled processResult for path: " + path);
                    }
                    return;
                }
                shard.readStatus();
            } else if (rc == KeeperException.Code.NONODE.intValue()) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.severe("StatusNodeWaiter.waitFor<"
                        + shard.statusPath() + ">: Node <" + path
                        + "> does not exists. " + "Waiting for watch trigger");
                }
                FileCreator fc = new FileCreator(shard,
                    shard.statusPath(),
                    Long.toString(-1).getBytes(),
                    this);
                fc.run();
                return;
            } else if (rc == KeeperException.Code.CONNECTIONLOSS.intValue()) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.severe("StatusNodeWaiter.waitFor<"
                        + shard.statusPath()
                        + ">: processResult error: connection loss");
                }
                shard.connloss();
            } else {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.severe("StatusNodeWaiter.waitFor<"
                        + shard.statusPath()
                        + ">: processResult unknown error: " + rc);
                }
                run();
            }
        }
    }

    @Override
    public void process(final WatchedEvent event) {
        synchronized(shard) {
            if (!checkOper()) return;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("StatusNodeWaiter.waitFor<" + shard.statusPath() +
                    ">: watched event " + event);
            }
            if (event.getState() == KeeperState.SyncConnected) {
                if (event.getType() == Watcher.Event.EventType.NodeCreated) {
                    shard.readStatus();
                } else {
                    if (logger.isLoggable(Level.SEVERE)) {
                        logger.severe("StatusNodeWaiter.waitFor<" +
                            shard.statusPath() + ">: unhandled event " + event);
                    }
                    shard.reset();
                }
            } else if (event.getState() == KeeperState.Expired) {
                run();
            } else if (event.getState() == KeeperState.Disconnected) {
                run();
            }
        }
    }
}
