package ru.yandex.dispatcher.producer;

import java.io.Closeable;
import java.io.IOException;

import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.nio.entity.ContentInputStream;
import org.apache.http.nio.util.ContentInputBuffer;

public class CloseableContentBufferEntity extends BasicHttpEntity
    implements Closeable
{
    private final HttpEntity wrappedEntity;
    private final ContentInputBuffer buffer;

    public CloseableContentBufferEntity(
        final HttpEntity entity,
        final ContentInputBuffer buffer)
    {
        super();
        this.wrappedEntity = entity;
        this.buffer = buffer;
        setContent(new ContentInputStream(buffer));
    }

    @Override
    public boolean isChunked() {
        return this.wrappedEntity.isChunked();
    }

    @Override
    public long getContentLength() {
        return this.wrappedEntity.getContentLength();
    }

    @Override
    public Header getContentType() {
        return this.wrappedEntity.getContentType();
    }

    @Override
    public Header getContentEncoding() {
        return this.wrappedEntity.getContentEncoding();
    }

    @Override
    public void close() throws IOException {
        if (buffer instanceof Closeable) {
            ((Closeable) buffer).close();
        }
    }
}
